cmake_minimum_required(VERSION 3.14.0)

string(TIMESTAMP SMTG_CURRENT_YEAR %Y)

set(SMTG_VENDOR_NAME "My Plug-in Company")
set(SMTG_VENDOR_HOMEPAGE "https://www.mycompanyname.com")
set(SMTG_VENDOR_EMAIL "info@mycompanyname.com")
set(SMTG_PLUGIN_NAME "My Plugin")
set(SMTG_PLUGIN_IDENTIFIER "com.mycompany.myplugin.vst3")

# Source code specifics
set(SMTG_VENDOR_NAMESPACE "MyCompanyName")
set(SMTG_PLUGIN_CLASS_NAME "MyPlugin")
set(SMTG_PREFIX_FOR_FILENAMES "myplugin")
set(SMTG_PLUGIN_BUNDLE_NAME "MyPlugin")
set(SMTG_PLUGIN_CATEGORY "Fx")
set(SMTG_MACOS_DEPLOYMENT_TARGET "10.12")

# Replace by command line arguments
if(SMTG_VENDOR_NAME_CLI)
    string(REPLACE "\"" "" SMTG_VENDOR_NAME ${SMTG_VENDOR_NAME_CLI})
endif()
if(SMTG_VENDOR_HOMEPAGE_CLI)
    string(REPLACE "\"" "" SMTG_VENDOR_HOMEPAGE ${SMTG_VENDOR_HOMEPAGE_CLI})
endif()
if(SMTG_VENDOR_EMAIL_CLI)
    string(REPLACE "\"" "" SMTG_VENDOR_EMAIL ${SMTG_VENDOR_EMAIL_CLI})
endif()
if(SMTG_PLUGIN_NAME_CLI)
    string(REPLACE "\"" "" SMTG_PLUGIN_NAME ${SMTG_PLUGIN_NAME_CLI})
endif()
if(SMTG_PREFIX_FOR_FILENAMES_CLI)
    string(REPLACE "\"" "" SMTG_PREFIX_FOR_FILENAMES ${SMTG_PREFIX_FOR_FILENAMES_CLI})
endif()
if(SMTG_PLUGIN_IDENTIFIER_CLI)
    string(REPLACE "\"" "" SMTG_PLUGIN_IDENTIFIER ${SMTG_PLUGIN_IDENTIFIER_CLI})
endif()
if(SMTG_PLUGIN_CLASS_NAME_CLI)
    string(REPLACE "\"" "" SMTG_PLUGIN_CLASS_NAME ${SMTG_PLUGIN_CLASS_NAME_CLI})
endif()
if(SMTG_VENDOR_NAMESPACE_CLI)
    string(REPLACE "\"" "" SMTG_VENDOR_NAMESPACE ${SMTG_VENDOR_NAMESPACE_CLI})
endif()
if(SMTG_PLUGIN_CATEGORY_CLI)
    string(REPLACE "\"" "" SMTG_PLUGIN_CATEGORY ${SMTG_PLUGIN_CATEGORY_CLI})
endif()
if(SMTG_PLUGIN_BUNDLE_NAME_CLI)
    string(REPLACE "\"" "" SMTG_PLUGIN_BUNDLE_NAME ${SMTG_PLUGIN_BUNDLE_NAME_CLI})
endif()
if(SMTG_CMAKE_PROJECT_NAME_CLI)
    string(REPLACE "\"" "" SMTG_CMAKE_PROJECT_NAME ${SMTG_CMAKE_PROJECT_NAME_CLI})
else()
    set(SMTG_CMAKE_PROJECT_NAME ${SMTG_PLUGIN_BUNDLE_NAME})
endif()
if(SMTG_MACOS_DEPLOYMENT_TARGET_CLI)
    string(REPLACE "\"" "" SMTG_MACOS_DEPLOYMENT_TARGET ${SMTG_MACOS_DEPLOYMENT_TARGET_CLI})
endif()

set(SMTG_SOURCE_COPYRIGHT_HEADER "Copyright(c) ${SMTG_CURRENT_YEAR} ${SMTG_VENDOR_NAME}.")

function(smtg_print_vendor_specifics)
    message(STATUS "SMTG_VENDOR_NAME            : ${SMTG_VENDOR_NAME}")
    message(STATUS "SMTG_VENDOR_HOMEPAGE        : ${SMTG_VENDOR_HOMEPAGE}")
    message(STATUS "SMTG_VENDOR_EMAIL           : ${SMTG_VENDOR_EMAIL}")
    message(STATUS "SMTG_SOURCE_COPYRIGHT_HEADER: ${SMTG_SOURCE_COPYRIGHT_HEADER}")
    message(STATUS "SMTG_PLUGIN_NAME            : ${SMTG_PLUGIN_NAME}")
    message(STATUS "SMTG_PREFIX_FOR_FILENAMES   : e.g. ${SMTG_PREFIX_FOR_FILENAMES}controller.h")
    message(STATUS "SMTG_PLUGIN_IDENTIFIER      : ${SMTG_PLUGIN_IDENTIFIER}, used e.g. in Info.plist")
    message(STATUS "SMTG_PLUGIN_BUNDLE_NAME     : ${SMTG_PLUGIN_BUNDLE_NAME}")
    message("")
    message(STATUS "SMTG_CMAKE_PROJECT_NAME     : e.g. ${SMTG_CMAKE_PROJECT_NAME} will output ${SMTG_CMAKE_PROJECT_NAME}.vst3")
    message(STATUS "SMTG_VENDOR_NAMESPACE       : e.g. namespace ${SMTG_VENDOR_NAMESPACE} {...}")
    message(STATUS "SMTG_PLUGIN_CLASS_NAME      : e.g. class ${SMTG_PLUGIN_CLASS_NAME}Processor : public AudioEffect {...}")
    message(STATUS "SMTG_PLUGIN_CATEGORY        : ${SMTG_PLUGIN_CATEGORY}")
    message(STATUS "SMTG_MACOS_DEPLOYMENT_TARGET: ${SMTG_MACOS_DEPLOYMENT_TARGET}")
    message("")
endfunction(smtg_print_vendor_specifics)
